/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.comparator.CompareUtil;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Editor;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.lang.Matcher;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.PrimitiveArrayUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;

public class ArrayUtil
extends PrimitiveArrayUtil {
    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static <T> T[] defaultIfEmpty(T[] array, T[] defaultArray) {
        return ArrayUtil.isEmpty(array) ? defaultArray : array;
    }

    public static boolean isEmpty(Object array) {
        if (array != null) {
            if (ArrayUtil.isArray(array)) {
                return 0 == Array.getLength(array);
            }
            return false;
        }
        return true;
    }

    public static <T> boolean isNotEmpty(T[] array) {
        return array != null && array.length != 0;
    }

    public static boolean isNotEmpty(Object array) {
        return false == ArrayUtil.isEmpty(array);
    }

    public static <T> boolean hasNull(T ... array) {
        if (ArrayUtil.isNotEmpty(array)) {
            for (T element : array) {
                if (null != element) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> boolean isAllNull(T ... array) {
        return null == ArrayUtil.firstNonNull(array);
    }

    public static <T> T firstNonNull(T ... array) {
        return (T)ArrayUtil.firstMatch(Objects::nonNull, array);
    }

    public static <T> T firstMatch(Matcher<T> matcher, T ... array) {
        if (ArrayUtil.isNotEmpty(array)) {
            for (T val : array) {
                if (!matcher.match(val)) continue;
                return val;
            }
        }
        return null;
    }

    public static <T> T[] newArray(Class<?> componentType, int newSize) {
        return (Object[])Array.newInstance(componentType, newSize);
    }

    public static Object[] newArray(int newSize) {
        return new Object[newSize];
    }

    public static Class<?> getComponentType(Object array) {
        return null == array ? null : array.getClass().getComponentType();
    }

    public static Class<?> getComponentType(Class<?> arrayClass) {
        return null == arrayClass ? null : arrayClass.getComponentType();
    }

    public static Class<?> getArrayType(Class<?> componentType) {
        return Array.newInstance(componentType, 0).getClass();
    }

    public static Object[] cast(Class<?> type, Object arrayObj) throws NullPointerException, IllegalArgumentException {
        if (null == arrayObj) {
            throw new NullPointerException("Argument [arrayObj] is null !");
        }
        if (!arrayObj.getClass().isArray()) {
            throw new IllegalArgumentException("Argument [arrayObj] is not array !");
        }
        if (null == type) {
            return (Object[])arrayObj;
        }
        Class<?> componentType = type.isArray() ? type.getComponentType() : type;
        Object[] array = (Object[])arrayObj;
        Object[] result = ArrayUtil.newArray(componentType, array.length);
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    @SafeVarargs
    public static <T> T[] append(T[] buffer, T ... newElements) {
        if (ArrayUtil.isEmpty(buffer)) {
            return newElements;
        }
        return ArrayUtil.insert(buffer, buffer.length, newElements);
    }

    @SafeVarargs
    public static <T> Object append(Object array, T ... newElements) {
        if (ArrayUtil.isEmpty(array)) {
            return newElements;
        }
        return ArrayUtil.insert(array, ArrayUtil.length(array), newElements);
    }

    public static <T> T[] setOrAppend(T[] buffer, int index, T value) {
        if (index < buffer.length) {
            Array.set(buffer, index, value);
            return buffer;
        }
        return ArrayUtil.append(buffer, value);
    }

    public static Object setOrAppend(Object array, int index, Object value) {
        if (index < ArrayUtil.length(array)) {
            Array.set(array, index, value);
            return array;
        }
        return ArrayUtil.append(array, value);
    }

    public static <T> T[] insert(T[] buffer, int index, T ... newElements) {
        return (Object[])ArrayUtil.insert(buffer, index, newElements);
    }

    public static <T> Object insert(Object array, int index, T ... newElements) {
        if (ArrayUtil.isEmpty(newElements)) {
            return array;
        }
        if (ArrayUtil.isEmpty(array)) {
            return newElements;
        }
        int len = ArrayUtil.length(array);
        if (index < 0) {
            index = index % len + len;
        }
        T[] result = ArrayUtil.newArray(array.getClass().getComponentType(), Math.max(len, index) + newElements.length);
        System.arraycopy(array, 0, result, 0, Math.min(len, index));
        System.arraycopy(newElements, 0, result, index, newElements.length);
        if (index < len) {
            System.arraycopy(array, index, result, index + newElements.length, len - index);
        }
        return result;
    }

    public static <T> T[] resize(T[] data, int newSize, Class<?> componentType) {
        if (newSize < 0) {
            return data;
        }
        T[] newArray = ArrayUtil.newArray(componentType, newSize);
        if (newSize > 0 && ArrayUtil.isNotEmpty(data)) {
            System.arraycopy(data, 0, newArray, 0, Math.min(data.length, newSize));
        }
        return newArray;
    }

    public static Object resize(Object array, int newSize) {
        if (newSize < 0) {
            return array;
        }
        if (null == array) {
            return null;
        }
        int length = ArrayUtil.length(array);
        Object newArray = Array.newInstance(array.getClass().getComponentType(), newSize);
        if (newSize > 0 && ArrayUtil.isNotEmpty(array)) {
            System.arraycopy(array, 0, newArray, 0, Math.min(length, newSize));
        }
        return newArray;
    }

    public static <T> T[] resize(T[] buffer, int newSize) {
        return ArrayUtil.resize(buffer, newSize, buffer.getClass().getComponentType());
    }

    @SafeVarargs
    public static <T> T[] addAll(T[] ... arrays) {
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (T[] array : arrays) {
            if (null == array) continue;
            length += array.length;
        }
        T[] result = ArrayUtil.newArray(arrays.getClass().getComponentType().getComponentType(), length);
        length = 0;
        for (T[] array : arrays) {
            if (null == array) continue;
            System.arraycopy(array, 0, result, length, array.length);
            length += array.length;
        }
        return result;
    }

    public static Object copy(Object src, int srcPos, Object dest, int destPos, int length) {
        System.arraycopy(src, srcPos, dest, destPos, length);
        return dest;
    }

    public static Object copy(Object src, Object dest, int length) {
        System.arraycopy(src, 0, dest, 0, length);
        return dest;
    }

    public static <T> T[] clone(T[] array) {
        if (array == null) {
            return null;
        }
        return (Object[])array.clone();
    }

    public static <T> T clone(T obj) {
        if (null == obj) {
            return null;
        }
        if (ArrayUtil.isArray(obj)) {
            Object result;
            Class<?> componentType = obj.getClass().getComponentType();
            if (componentType.isPrimitive()) {
                int length = Array.getLength(obj);
                result = Array.newInstance(componentType, length);
                while (length-- > 0) {
                    Array.set(result, length, Array.get(obj, length));
                }
            } else {
                result = ((Object[])obj).clone();
            }
            return (T)result;
        }
        return null;
    }

    public static <T> T[] filter(T[] array, Editor<T> editor) {
        ArrayList<T> list = new ArrayList<T>(array.length);
        for (T t : array) {
            T modified = editor.edit(t);
            if (null == modified) continue;
            list.add(modified);
        }
        return list.toArray(Arrays.copyOf(array, list.size()));
    }

    public static <T> void edit(T[] array, Editor<T> editor) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = editor.edit(array[i]);
        }
    }

    public static <T> T[] filter(T[] array, Filter<T> filter) {
        if (null == filter) {
            return array;
        }
        ArrayList<T> list = new ArrayList<T>(array.length);
        for (T t : array) {
            if (!filter.accept(t)) continue;
            list.add(t);
        }
        T[] result = ArrayUtil.newArray(array.getClass().getComponentType(), list.size());
        return list.toArray(result);
    }

    public static <T> T[] removeNull(T[] array) {
        return ArrayUtil.filter(array, (T t) -> t);
    }

    public static <T extends CharSequence> T[] removeEmpty(T[] array) {
        return ArrayUtil.filter(array, (T t) -> false == StrUtil.isEmpty(t));
    }

    public static <T extends CharSequence> T[] removeBlank(T[] array) {
        return ArrayUtil.filter(array, (T t) -> false == StrUtil.isBlank(t));
    }

    public static String[] nullToEmpty(String[] array) {
        return ArrayUtil.filter(array, (T t) -> null == t ? "" : t);
    }

    public static <K, V> Map<K, V> zip(K[] keys, V[] values, boolean isOrder) {
        if (ArrayUtil.isEmpty(keys) || ArrayUtil.isEmpty(values)) {
            return null;
        }
        int size = Math.min(keys.length, values.length);
        HashMap<K, V> map = CollUtil.newHashMap(size, isOrder);
        for (int i = 0; i < size; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static <K, V> Map<K, V> zip(K[] keys, V[] values) {
        return ArrayUtil.zip(keys, values, false);
    }

    public static <T> int indexOf(T[] array, Object value) {
        if (null != array) {
            for (int i = 0; i < array.length; ++i) {
                if (!ObjectUtil.equal(value, array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOfIgnoreCase(CharSequence[] array, CharSequence value) {
        if (null != array) {
            for (int i = 0; i < array.length; ++i) {
                if (!StrUtil.equalsIgnoreCase(array[i], value)) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> int lastIndexOf(T[] array, Object value) {
        if (null != array) {
            for (int i = array.length - 1; i >= 0; --i) {
                if (!ObjectUtil.equal(value, array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> boolean contains(T[] array, T value) {
        return ArrayUtil.indexOf(array, value) > -1;
    }

    public static <T> boolean containsAny(T[] array, T ... values) {
        for (T value : values) {
            if (!ArrayUtil.contains(array, value)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean containsAll(T[] array, T ... values) {
        for (T value : values) {
            if (ArrayUtil.contains(array, value)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsIgnoreCase(CharSequence[] array, CharSequence value) {
        return ArrayUtil.indexOfIgnoreCase(array, value) > -1;
    }

    public static Object[] wrap(Object obj) {
        if (null == obj) {
            return null;
        }
        if (ArrayUtil.isArray(obj)) {
            try {
                return (Object[])obj;
            }
            catch (Exception e) {
                String className;
                switch (className = obj.getClass().getComponentType().getName()) {
                    case "long": {
                        return ArrayUtil.wrap((long[])obj);
                    }
                    case "int": {
                        return ArrayUtil.wrap((int[])obj);
                    }
                    case "short": {
                        return ArrayUtil.wrap((short[])obj);
                    }
                    case "char": {
                        return ArrayUtil.wrap((char[])obj);
                    }
                    case "byte": {
                        return ArrayUtil.wrap((byte[])obj);
                    }
                    case "boolean": {
                        return ArrayUtil.wrap((boolean[])obj);
                    }
                    case "float": {
                        return ArrayUtil.wrap((float[])obj);
                    }
                    case "double": {
                        return ArrayUtil.wrap((double[])obj);
                    }
                }
                throw new UtilException(e);
            }
        }
        throw new UtilException(StrUtil.format("[{}] is not Array!", obj.getClass()));
    }

    public static boolean isArray(Object obj) {
        if (null == obj) {
            return false;
        }
        return obj.getClass().isArray();
    }

    public static <T> T get(Object array, int index) {
        if (null == array) {
            return null;
        }
        if (index < 0) {
            index += Array.getLength(array);
        }
        try {
            return (T)Array.get(array, index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public static <T> T[] getAny(Object array, int ... indexes) {
        if (null == array) {
            return null;
        }
        T[] result = ArrayUtil.newArray(array.getClass().getComponentType(), indexes.length);
        for (int i : indexes) {
            result[i] = ArrayUtil.get(array, i);
        }
        return result;
    }

    public static <T> T[] sub(T[] array, int start, int end) {
        int length = ArrayUtil.length(array);
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return ArrayUtil.newArray(array.getClass().getComponentType(), 0);
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            if (start >= length) {
                return ArrayUtil.newArray(array.getClass().getComponentType(), 0);
            }
            end = length;
        }
        return Arrays.copyOfRange(array, start, end);
    }

    public static Object[] sub(Object array, int start, int end) {
        return ArrayUtil.sub(array, start, end, 1);
    }

    public static Object[] sub(Object array, int start, int end, int step) {
        int length = ArrayUtil.length(array);
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return new Object[0];
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            if (start >= length) {
                return new Object[0];
            }
            end = length;
        }
        if (step <= 1) {
            step = 1;
        }
        ArrayList list = new ArrayList();
        for (int i = start; i < end; i += step) {
            list.add(ArrayUtil.get(array, i));
        }
        return list.toArray();
    }

    public static String toString(Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof long[]) {
            return Arrays.toString((long[])obj);
        }
        if (obj instanceof int[]) {
            return Arrays.toString((int[])obj);
        }
        if (obj instanceof short[]) {
            return Arrays.toString((short[])obj);
        }
        if (obj instanceof char[]) {
            return Arrays.toString((char[])obj);
        }
        if (obj instanceof byte[]) {
            return Arrays.toString((byte[])obj);
        }
        if (obj instanceof boolean[]) {
            return Arrays.toString((boolean[])obj);
        }
        if (obj instanceof float[]) {
            return Arrays.toString((float[])obj);
        }
        if (obj instanceof double[]) {
            return Arrays.toString((double[])obj);
        }
        if (ArrayUtil.isArray(obj)) {
            try {
                return Arrays.deepToString((Object[])obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return obj.toString();
    }

    public static int length(Object array) throws IllegalArgumentException {
        if (null == array) {
            return 0;
        }
        return Array.getLength(array);
    }

    public static <T> String join(T[] array, CharSequence conjunction) {
        return ArrayUtil.join(array, conjunction, null, null);
    }

    public static <T> String join(T[] array, CharSequence conjunction, String prefix, String suffix) {
        if (null == array) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (T item : array) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            if (ArrayUtil.isArray(item)) {
                sb.append(ArrayUtil.join(ArrayUtil.wrap(item), conjunction, prefix, suffix));
                continue;
            }
            if (item instanceof Iterable) {
                sb.append(CollUtil.join((Iterable)item, conjunction, prefix, suffix));
                continue;
            }
            if (item instanceof Iterator) {
                sb.append(IterUtil.join((Iterator)item, conjunction, prefix, suffix));
                continue;
            }
            sb.append(StrUtil.wrap(StrUtil.toString(item), prefix, suffix));
        }
        return sb.toString();
    }

    public static <T> String join(T[] array, CharSequence conjunction, Editor<T> editor) {
        if (null == array) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (T item : array) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            if (null != editor) {
                item = editor.edit(item);
            }
            if (null == item) continue;
            sb.append(StrUtil.toString(item));
        }
        return sb.toString();
    }

    public static String join(long[] array, CharSequence conjunction) {
        if (null == array) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (long item : array) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static String join(Object array, CharSequence conjunction) {
        if (ArrayUtil.isArray(array)) {
            Class<?> componentType = array.getClass().getComponentType();
            if (componentType.isPrimitive()) {
                String componentTypeName;
                switch (componentTypeName = componentType.getName()) {
                    case "long": {
                        return ArrayUtil.join((long[])array, conjunction);
                    }
                    case "int": {
                        return ArrayUtil.join((int[])array, conjunction);
                    }
                    case "short": {
                        return ArrayUtil.join((short[])array, conjunction);
                    }
                    case "char": {
                        return ArrayUtil.join((char[])array, conjunction);
                    }
                    case "byte": {
                        return ArrayUtil.join((byte[])array, conjunction);
                    }
                    case "boolean": {
                        return ArrayUtil.join((boolean[])array, conjunction);
                    }
                    case "float": {
                        return ArrayUtil.join((float[])array, conjunction);
                    }
                    case "double": {
                        return ArrayUtil.join((double[])array, conjunction);
                    }
                }
                throw new UtilException("Unknown primitive type: [{}]", componentTypeName);
            }
            return ArrayUtil.join((Object[])array, conjunction);
        }
        throw new UtilException(StrUtil.format("[{}] is not a Array!", array.getClass()));
    }

    public static byte[] toArray(ByteBuffer bytebuffer) {
        if (!bytebuffer.hasArray()) {
            int oldPosition = bytebuffer.position();
            bytebuffer.position(0);
            int size = bytebuffer.limit();
            byte[] buffers = new byte[size];
            bytebuffer.get(buffers);
            bytebuffer.position(oldPosition);
            return buffers;
        }
        return Arrays.copyOfRange(bytebuffer.array(), bytebuffer.position(), bytebuffer.limit());
    }

    public static <T> T[] toArray(Iterator<T> iterator, Class<T> componentType) {
        return ArrayUtil.toArray(CollUtil.newArrayList(iterator), componentType);
    }

    public static <T> T[] toArray(Iterable<T> iterable, Class<T> componentType) {
        return ArrayUtil.toArray(CollectionUtil.toCollection(iterable), componentType);
    }

    public static <T> T[] toArray(Collection<T> collection, Class<T> componentType) {
        return collection.toArray(ArrayUtil.newArray(componentType, 0));
    }

    public static <T> T[] remove(T[] array, int index) throws IllegalArgumentException {
        return (Object[])ArrayUtil.remove(array, index);
    }

    public static <T> T[] removeEle(T[] array, T element) throws IllegalArgumentException {
        return ArrayUtil.remove(array, ArrayUtil.indexOf(array, element));
    }

    public static <T> T[] reverse(T[] array, int startIndexInclusive, int endIndexExclusive) {
        if (ArrayUtil.isEmpty(array)) {
            return array;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            T tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
        return array;
    }

    public static <T> T[] reverse(T[] array) {
        return ArrayUtil.reverse(array, 0, array.length);
    }

    public static <T extends Comparable<? super T>> T min(T[] numberArray) {
        return (T)ArrayUtil.min(numberArray, null);
    }

    public static <T extends Comparable<? super T>> T min(T[] numberArray, Comparator<T> comparator) {
        if (ArrayUtil.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        T min = numberArray[0];
        for (T t : numberArray) {
            if (CompareUtil.compare(min, t, comparator) <= 0) continue;
            min = t;
        }
        return min;
    }

    public static <T extends Comparable<? super T>> T max(T[] numberArray) {
        return (T)ArrayUtil.max(numberArray, null);
    }

    public static <T extends Comparable<? super T>> T max(T[] numberArray, Comparator<T> comparator) {
        if (ArrayUtil.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        T max = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (CompareUtil.compare(max, numberArray[i], comparator) >= 0) continue;
            max = numberArray[i];
        }
        return max;
    }

    public static <T> T[] shuffle(T[] array) {
        return ArrayUtil.shuffle(array, (Random)RandomUtil.getRandom());
    }

    public static <T> T[] shuffle(T[] array, Random random) {
        if (array == null || random == null || array.length <= 1) {
            return array;
        }
        for (int i = array.length; i > 1; --i) {
            ArrayUtil.swap(array, i - 1, random.nextInt(i));
        }
        return array;
    }

    public static <T> T[] swap(T[] array, int index1, int index2) {
        if (ArrayUtil.isEmpty(array)) {
            throw new IllegalArgumentException("Array must not empty !");
        }
        T tmp = array[index1];
        array[index1] = array[index2];
        array[index2] = tmp;
        return array;
    }

    public static Object swap(Object array, int index1, int index2) {
        if (ArrayUtil.isEmpty(array)) {
            throw new IllegalArgumentException("Array must not empty !");
        }
        Object tmp = ArrayUtil.get(array, index1);
        Array.set(array, index1, Array.get(array, index2));
        Array.set(array, index2, tmp);
        return array;
    }

    public static int emptyCount(Object ... args) {
        int count = 0;
        if (ArrayUtil.isNotEmpty(args)) {
            for (Object element : args) {
                if (!ObjectUtil.isEmpty(element)) continue;
                ++count;
            }
        }
        return count;
    }

    public static boolean hasEmpty(Object ... args) {
        if (ArrayUtil.isNotEmpty(args)) {
            for (Object element : args) {
                if (!ObjectUtil.isEmpty(element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAllEmpty(Object ... args) {
        return ArrayUtil.emptyCount(args) == args.length;
    }

    public static boolean isAllNotEmpty(Object ... args) {
        return false == ArrayUtil.hasEmpty(args);
    }

    public static <T> boolean isAllNotNull(T ... array) {
        return false == ArrayUtil.hasNull(array);
    }

    public static <T> T[] distinct(T[] array) {
        if (ArrayUtil.isEmpty(array)) {
            return array;
        }
        LinkedHashSet set = new LinkedHashSet(array.length, 1.0f);
        Collections.addAll(set, array);
        return ArrayUtil.toArray(set, ArrayUtil.getComponentType(array));
    }

    public static <T, R> R[] map(T[] array, Class<R> targetComponentType, Function<? super T, ? extends R> func) {
        T[] result = ArrayUtil.newArray(targetComponentType, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = func.apply(array[i]);
        }
        return result;
    }

    public static boolean equals(Object array1, Object array2) {
        if (array1 == array2) {
            return true;
        }
        if (ArrayUtil.hasNull(array1, array2)) {
            return false;
        }
        Assert.isTrue(ArrayUtil.isArray(array1), "First is not a Array !", new Object[0]);
        Assert.isTrue(ArrayUtil.isArray(array2), "Second is not a Array !", new Object[0]);
        if (array1.getClass() != array2.getClass()) {
            return false;
        }
        if (array1 instanceof long[]) {
            return Arrays.equals((long[])array1, (long[])array2);
        }
        if (array1 instanceof int[]) {
            return Arrays.equals((int[])array1, (int[])array2);
        }
        if (array1 instanceof short[]) {
            return Arrays.equals((short[])array1, (short[])array2);
        }
        if (array1 instanceof char[]) {
            return Arrays.equals((char[])array1, (char[])array2);
        }
        if (array1 instanceof byte[]) {
            return Arrays.equals((byte[])array1, (byte[])array2);
        }
        if (array1 instanceof double[]) {
            return Arrays.equals((double[])array1, (double[])array2);
        }
        if (array1 instanceof float[]) {
            return Arrays.equals((float[])array1, (float[])array2);
        }
        if (array1 instanceof boolean[]) {
            return Arrays.equals((boolean[])array1, (boolean[])array2);
        }
        return Arrays.deepEquals((Object[])array1, (Object[])array2);
    }

    public static <T> boolean isSub(T[] array, T[] subArray) {
        return ArrayUtil.indexOfSub(array, subArray) > -1;
    }

    public static <T> int indexOfSub(T[] array, T[] subArray) {
        if (ArrayUtil.isEmpty(array) || ArrayUtil.isEmpty(subArray) || subArray.length > array.length) {
            return -1;
        }
        int firstIndex = ArrayUtil.indexOf(array, subArray[0]);
        if (firstIndex < 0 || firstIndex + subArray.length > array.length) {
            return -1;
        }
        for (int i = 0; i < subArray.length; ++i) {
            if (ObjectUtil.equal(array[i + firstIndex], subArray[i])) continue;
            return -1;
        }
        return firstIndex;
    }

    public static <T> int lastIndexOfSub(T[] array, T[] subArray) {
        if (ArrayUtil.isEmpty(array) || ArrayUtil.isEmpty(subArray) || subArray.length > array.length) {
            return -1;
        }
        int firstIndex = ArrayUtil.lastIndexOf(array, subArray[0]);
        if (firstIndex < 0 || firstIndex + subArray.length > array.length) {
            return -1;
        }
        for (int i = 0; i < subArray.length; ++i) {
            if (ObjectUtil.equal(array[i + firstIndex], subArray[i])) continue;
            return -1;
        }
        return firstIndex;
    }

    public static <T> boolean isSorted(T[] array, Comparator<? super T> comparator) {
        if (array == null || comparator == null) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (comparator.compare(array[i], array[i + 1]) <= 0) continue;
            return false;
        }
        return true;
    }

    public static <T extends Comparable<? super T>> boolean isSorted(T[] array) {
        return ArrayUtil.isSortedASC(array);
    }

    public static <T extends Comparable<? super T>> boolean isSortedASC(T[] array) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i].compareTo(array[i + 1]) <= 0) continue;
            return false;
        }
        return true;
    }

    public static <T extends Comparable<? super T>> boolean isSortedDESC(T[] array) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i].compareTo(array[i + 1]) >= 0) continue;
            return false;
        }
        return true;
    }
}

